#  
#  WordCompounder --- Executable file name: GoMusubi
#  Copyright(C) 2021 Kaoru Sagara and Syugo Nakamura 
#  This software is released under any of the GPL (see the file GPL), the LGPL(see the file LGPL), or the BSD License (see the file BSD).

import configparser


def get_default_configs():
  """
  config.iniの初期値を返す。

  Returns:
      dict: 初期値データ
  """
  default_configs = {
    'Dictionary': {
      'IPADIC_SYSTEM_DIR': '',
      'IPADIC_USER_FILE': '',
      'UNIDIC_SYSTEM_DIR': '',
      'UNIDIC_USER_FILE': '',
    },
    'Output': {
      'DEFAULT_OUTPUT_DIR': '',
      'IPADIC_OUTPUT_FILENAME': 'IpadicOutput.tsv',
      'UNIDIC_OUTPUT_FILENAME': 'UnidicOutput.tsv',
      'RESULT_OUTPUT_FILENAME': 'ResultOutput.tsv',
      'COMPOUND_WORD_FILENAME': 'CompoundWords.txt',
      'CP932': False,
    }
  }
  return default_configs


def init_configparser(config_filepath):
  config = configparser.ConfigParser()
  default_configs = get_default_configs()
  config.read_dict(default_configs)
  config.read(config_filepath)
  return config